include(`domains.m4')
variety : type. %name variety V.
cutful : variety.
cutfree : variety.

hyp : form -> type. %name hyp H.
conc : variety -> form -> type. %name conc SP.

%abbrev
conc' = conc cutfree.

%abbrev
conc* = conc cutful.

cut : conc V A -> (hyp A -> conc V B)
               -> conc* B.

ax : hyp F -> conc V F.

andr : conc V F1 -> conc V F2 -> conc V (F1 /\ F2).
andl1 : (hyp F1 -> conc V C)
         -> (hyp (F1 /\ F2) -> conc V C).
andl2 : (hyp F2 -> conc V C)
         -> (hyp (F1 /\ F2) -> conc V C).
orr1 : conc V F
        -> conc V (F \/ G).
orr2 : conc V G
        -> conc V (F \/ G).
orl : (hyp F -> conc V C) -> (hyp G -> conc V C)
        -> (hyp (F \/ G) -> conc V C).
impr : (hyp F -> conc V G)
        -> conc V (F ==> G).
impl : conc V F
        -> (hyp G -> conc V C)
        -> (hyp (F ==> G) -> conc V C).
topr : conc V top.
undivert(DIV_ASSERT)

% Some useful parameter reorderings:
andl1' : hyp (F1 /\ F2) -> (hyp F1 -> conc V C) -> conc V C
  = [h][p] andl1 p h.
andl2' : hyp (F1 /\ F2) -> (hyp F2 -> conc V C) -> conc V C = [h][p] andl2 p h.

include(`assert.inc')

%block bconc : some {F:form} block {_:conc* F}.
%block bconc2 : some {R:exp -> exp -> form} {S:exp -> exp -> form}
                 block
                 {_:{x:exp}{x':exp} conc* (R x x') -> conc* (S x x')}.
%block bhyp : some {F:form} block {h:hyp F}.
%block bdata : some {D:dform} block {x:data D}.
%worlds (bdata | bexp | bexp2 | bnat | bhyp) (hyp _).
%worlds (bdata | bexp | bexp2 | bnat | bhyp | bconc | bconc2) (conc _ _).

divert(-1)
undivert